/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;


/**
 * 
 */
public class MetaComponent<T> implements Component<T> {

	public interface MetaVisitor<T> {
		public void visit(Component<T> component);
	}
	
	private HashMap<OutputPort<T>,WireImpl<T>> sourceWireMap;
	private ArrayList<Wire<T>> wires;
	private HashSet<Component<T>> subComponents;
	private ArrayList<InputPort<T>> externalInputs = new ArrayList<InputPort<T>>();
	private ArrayList<OutputPort<T>> externalOutputs = new ArrayList<OutputPort<T>>();

	public void accept(MetaVisitor<T> v) {
		for (Component<T> item : subComponents) {
			v.visit(item);
		}
	}
	
	public int getInputSize() {
		return externalInputs.size();
	}

	public int getOutputSize() {
		return externalOutputs.size();
	}
	
	public InputPort<T> getInputPort(int index) {
		return externalInputs.get(index);
	}

	public OutputPort<T> getOutputPort(int index) {
		return externalOutputs.get(index);
	}
	
	public MetaComponent() {
		subComponents = new HashSet<Component<T>>();
		wires = new ArrayList<Wire<T>>();
		sourceWireMap = new HashMap<OutputPort<T>,WireImpl<T>>();
	}

	public void addConnection(OutputPort<T> src, InputPort<T>... targets) {
		for (InputPort<T> target : targets) {
			addConnection(src, target);
		}
	}
	
	public void addConnection(OutputPort<T> src, InputPort<T> target) {
		// dodaj komponenty nadrzdne portw do listy
		subComponents.add(src.getParent());
		subComponents.add(target.getParent());
		WireImpl<T> srcWire = sourceWireMap.get(src);
		if (srcWire == null) {
			// utwrz nowe poczenie
			srcWire = new WireImpl<T>(src);
			sourceWireMap.put(src, srcWire);
		}
		// TODO: usu stare poczenia uywajce portu docelowego?
		// dodaj port docelowy do poczenia
		srcWire.addTargetPort(target);
	}

	private void propagateSignals() {
		for (Wire<T> w : wires) {
			w.propagateSignal();
		}
	}
	
	private void processSubComponents() {
		for (Component<T> item : subComponents) {
			item.process();
		}
	}
	
	public void process() {
		processSubComponents();
		propagateSignals();
	}
	
	public void processRepeat(int count) {
		if (count <= 0) {
			return;
		}
		for (int i=0; i<count; i++) {
			process();
		}
	}

	public void addExternalPort(InputPort<T> port) {
		subComponents.add(port.getParent());
		externalInputs.add(port);
	}
	
	public void addExternalPort(OutputPort<T> port) {
		subComponents.add(port.getParent());
		externalOutputs.add(port);
	}
}
